#ifndef TFT_LIB_H
#define TFT_LIB_H

//#include <stdint.h>//uint16_t  not found
//#include <stdio.h>
//#include <string.h>
#include <wiringPi.h>

#include <QDebug>
#include <QPixmap>


//FUNCIONES PARA LAS OPERACIONES DE BIT A BIT
// BIT(x) devuelve un único bit x puesto a uno y los demas bits en cero, ej. BIT(3) devuelve 00001000
#define BIT(x)         (1<<(x))
// BIT_GET(x,b) devuelve el bit b-esimo de x ej. BIT_GET(PINC,3)
#define BIT_GET(x,b)   ((x) & BIT(b))
// BIT_SET(x,b) establece en '1' el bit b de x ej. BIT_SET(PORTD,4)
#define BIT_SET(x,b)   ((x) |= BIT(b))
// BIT_CLEAR(x,b) establece a '0' el bit b de x
#define BIT_CLEAR(x,b) ((x) &= ~BIT(b))
// BIT_TOGGLE(x,b) invierte el valor del bit b de x a su complemento,
#define BIT_TOGGLE(x,b)  ((x) ^= BIT(b))
// BIT_WRITE(x,b,v) establece el valor 'v' de
#define BIT_WRITE(x,b,v) ((v)? BIT_SET(x,b) : BIT_CLEAR(x,b))

#define RED				0xf800
#define GREEN			0x07e0
#define BLUE			0x001f
#define BLACK			0x0000
#define WHITE			0xffff
#define GRAY			0x8c51
#define YELLOW			0xFFE0
#define CYAN			0x07FF
#define PURPLE			0xF81F

#define DIRECTION0		0
#define DIRECTION90		1
#define DIRECTION180	2
#define DIRECTION270	3

#define TFTLCD_DELAY   0xFFFF
#define TFTLCD_DELAY16 0xFFFF
#define TFTLCD_DELAY8  0x7F

#define DRIVER_NAME "ILI9488"
#define SCREEN_WIDTH	320
#define SCREEN_HEIGHT 480
#define OFFSET_X 0
#define OFFSET_Y 0
//#define INIT_FUNCTION(a, b, c, d, e) ili9488_lcdInit(a, b, c, d, e)

static const uint8_t reset_off[9] = {
    0x01, 0,			//Soft Reset
    TFTLCD_DELAY8, 150,
    0x28, 0,			//Display Off
    0x3A, 1, 0x55,		//Pixel read=565, write=565.
};

static const uint8_t wake_on[] = {
    0x11, 0,			//Sleep Out
    TFTLCD_DELAY8, 150,
    0x29, 0,			//Display On
};

static const uint8_t regValues[] = {
    0xC0, 2, 0x10, 0x10,		//Power Control 1 [0E 0E]
    0xC1, 1, 0x41,		//Power Control 2 [43]
    0xC5, 4, 0x00, 0x22, 0x80, 0x40,	//VCOM	Control 1 [00 40 00 40]
    //0x36, 1, 0x68,		//Memory Access [00]
    //0x36, 1, 0x98,	  //Memory Access [00]
    0x36, 1, 0x18,	  //Memory Access [00]
    0xB0, 1, 0x00,		//Interface		[00]
    0xB1, 2, 0xB0, 0x11,		//Frame Rate Control [B0 11]
    0xB4, 1, 0x02,		//Inversion Control [02]
    0xB6, 3, 0x02, 0x02, 0x3B,	// Display Function Control [02 02 3B] .kbv NL=480
    0xB7, 1, 0xC6,		//Entry Mode	  [06]
    0x3A, 2, 0x55, 		//Interlace Pixel Format [XX]
    0xF7, 4, 0xA9, 0x51, 0x2C, 0x82,	//Adjustment Control 3 [A9 51 2C 82]
};

class TFT_lib: public QObject
{
    Q_OBJECT
private:
    typedef struct {
        int rst;
        int cs;
        int rs;
        int wr;
        int rd;
        int d0;
        int d1;
        int d2;
        int d3;
        int d4;
        int d5;
        int d6;
        int d7;
    } GPIO_t;

    typedef struct {
        uint16_t _model;
        uint16_t _width;
        uint16_t _height;
        uint16_t _offsetx;
        uint16_t _offsety;
        int16_t _font_direction;
        int16_t _font_fill;
        uint16_t _font_fill_color;
        int16_t _font_underline;
        uint16_t _font_underline_color;
        GPIO_t	pins;
        int16_t _delay;
        bool _debug;
    } TFT_t;
    uint16_t rgb565_conv(uint16_t r,uint16_t g,uint16_t b)
    {
       unsigned int RR,GG,BB;
       RR = (r * 31 / 255) << 11;
       GG = (g * 63 / 255) << 5;
       BB = (b * 31 / 255);
       return(RR | GG | BB);
    }
    bool _DEBUG_=false;
    bool _DEBUG_PIXEL_=false;
    bool _DEBUG_WRITE_BYTE_=false;

private:
    void drawFillRect(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color);
    void setInterface(TFT_t *dev, char* ppath);
    int ReadPinConfig(GPIO_t *pin, char *path);
    void initLcd(uint16_t model, int width, int height, int offsetx, int offsety);

    void initTables();

    void lcdInitTable(const void *table, int16_t size);
    void lcdWriteCommandByte( uint8_t command);
    void lcdWriteByte(uint8_t data);
    void lcdWriteDataWord(uint16_t data);
    void lcdWriteDataByte(uint8_t data);
    //Funciones para la manipulación de los datos bit a bit
    uint8_t toLSB(uint8_t data);
    QString show16Bits(uint16_t data);
    QString show8Bits(uint8_t data);




public:
    TFT_lib();
    TFT_t dev;

    void lcdReset();
    void lcdDisplayOff();
    void lcdDisplayOn() ;

    void drawPixel(uint16_t x, uint16_t y, uint16_t color);

//    void displayOff();
//    void displayOn();
    void inversionOff();
    void inversionOn();
    void drawImage(QImage image);


//    void lcdDelay(int ms);

    //void lcdWriteByteLSB(uint8_t data);

//    void lcdWriteWord(uint16_t data);


//    void lcdWriteDataWord_16bit(uint16_t data);
//    void lcdWriteCommandWord(uint16_t command);

//    void lcdWriteRegisterWord(TFT_t *dev, uint16_t addr, uint16_t data);
//    void lcdWriteRegisterByte(uint8_t addr, uint16_t data);

//    void lcdInitResetTable();
//    void lcdInintRegValuesTable();



//    void lcdDrawPixel(uint16_t x, uint16_t y, uint16_t color);

    void lcdDrawFillRect(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color);
//    void lcdDisplayOff(TFT_t *dev);
//    void lcdDisplayOn(TFT_t *dev);
//    void lcdInversionOn(TFT_t *dev);
//    void lcdInversionOff(TFT_t *dev);
    void fillScreen(uint16_t color);
//    void lcdFadeout(TFT_t *dev, int direction, uint16_t color);

//    void lcdDrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color);
//    void lcdDrawRect(TFT_t *dev, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color);
//    void lcdDrawCircle(TFT_t *dev, uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);
//    void lcdDrawFillCircle(TFT_t *dev, uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);
//    void lcdDrawRoundRect(TFT_t *dev, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t r, uint16_t color);
//    void lcdDrawArrow(TFT_t *dev, uint16_t x0,uint16_t y0,uint16_t x1,uint16_t y1,uint16_t w,uint16_t color);
//    void lcdDrawFillArrow(TFT_t *dev, uint16_t x0,uint16_t y0,uint16_t x1,uint16_t y1,uint16_t w,uint16_t color);
//    uint16_t rgb565_conv(uint16_t r,uint16_t g,uint16_t b);
/*    int lcdDrawSJISChar(TFT_t *dev, FontxFile *fx, uint16_t x,uint16_t y,uint16_t sjis,uint16_t color);
    int lcdDrawUTF8Char(TFT_t *dev, FontxFile *fx, uint16_t x,uint16_t y,uint8_t *utf8,uint16_t color);
    int lcdDrawUTF8String(TFT_t *dev, FontxFile *fx, uint16_t x,uint16_t y,unsigned char *utfs,uint16_t color);
*/
//    void lcdSetFontDirection(TFT_t *dev, uint16_t dir);
//    void lcdSetFontFill(TFT_t *dev, uint16_t color);
//    void lcdUnsetFontFill(TFT_t *dev);
//    void lcdSetFontUnderLine(TFT_t *dev, uint16_t color);
//    void lcdUnsetFontUnderLine(TFT_t *dev);


};

#endif // TFT_LIB_H

