#include "tft_lib.h"

TFT_lib::TFT_lib()
{
    char base[128];
    strcpy(base, "./");

    // set full path of pin.conf
    char ppath[128];
    strcpy(ppath,base);
    strcat(ppath,"pin.conf");
    if(_DEBUG_)qDebug()<<"\x1B[31mConfig ppath= "<<ppath;


    setInterface(&dev, ppath);
    if(_DEBUG_)qDebug()<<"\x1B[0mInicializando pantalla con los datos: 0x9488, ancho= "<<SCREEN_WIDTH<<", alto= "<<SCREEN_HEIGHT<<", offset X= "<<OFFSET_X<<", offsetY=  "<<OFFSET_Y;
    initLcd(0x9488,SCREEN_WIDTH,SCREEN_HEIGHT,OFFSET_X,OFFSET_Y);//	INIT_FUNCTION(&dev, SCREEN_WIDTH, SCREEN_HEIGHT, OFFSET_X, OFFSET_Y);

    lcdReset();

    if(_DEBUG_){
        qDebug()<<"Your TFT controller is "<<DRIVER_NAME<<"\n";
        qDebug()<<"TFT resolution is "<<SCREEN_WIDTH << " x " << SCREEN_HEIGHT<<"\n";
        qDebug()<<"RST pin= "<<dev.pins.rst;
        qDebug()<<"CS pin= "<<dev.pins.cs;
        qDebug()<<"RS pin= "<<dev.pins.rs;
        qDebug()<<"WR pin= "<<dev.pins.wr;
        qDebug()<<"RD pin= "<<dev.pins.rd;
        qDebug()<<"D0 pin= "<<dev.pins.d0;
        qDebug()<<"D1 pin= "<<dev.pins.d1;
        qDebug()<<"D2 pin= "<<dev.pins.d2;
        qDebug()<<"D3 pin= "<<dev.pins.d3;
        qDebug()<<"D4 pin= "<<dev.pins.d4;
        qDebug()<<"D5 pin= "<<dev.pins.d5;
        qDebug()<<"D6 pin= "<<dev.pins.d6;
        qDebug()<<"D7 pin= "<<dev.pins.d7;
    }
    inversionOff();
/*
    int init=50;
    int xPixels=1;
    int jinit=50;
    int yPixels=1;

    for(uint16_t i=init;i<init+xPixels;i++)
        for(uint16_t j=jinit;j<jinit+yPixels;j++)
            drawPixel(j,i,GREEN);
    */
/*
    uint16_t color;
    int width=dev._height;
    int height=dev._height;
    lcdFillScreen(WHITE);
    color = RED;
    uint16_t delta = height/16;
    uint16_t ypos = 0;
    int i;
    for(i=0;i<16;i++) {
        lcdDrawFillRect(0, ypos, width-1, ypos+delta, color);
        color = color >> 1;
        ypos = ypos + delta;
    }
*/


    //displayOn();
    //lcdFillScreen(BLACK);

}

void TFT_lib::drawPixel(uint16_t x, uint16_t y, uint16_t color)
{
    if (x >= dev._width) return;
    if (y >= dev._height) return;

    uint16_t _x = x + dev._offsetx;
    uint16_t _y = y + dev._offsety;

    lcdWriteCommandByte(0x2A); // set column(x) address
    lcdWriteDataWord(_x);
    lcdWriteDataWord(_x);
    lcdWriteCommandByte(0x2B); // set Page(y) address
    lcdWriteDataWord(_y);
    lcdWriteDataWord(_y);
    lcdWriteCommandByte(0x2C); // Memory Write
    lcdWriteDataWord(color);

}
/*
void TFT_lib::drawFillRect(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color)
{

    if (x1 >= dev._width) return;
    if (x2 >= dev._width) x2 = dev._width-1;
    if (y1 >= dev._height) return;
    if (y2 >= dev._height) y2 = dev._height-1;

    uint16_t _x1 = x1 + dev._offsetx;
    uint16_t _x2 = x2 + dev._offsetx;
    uint16_t _y1 = y1 + dev._offsety;
    uint16_t _y2 = y2 + dev._offsety;

    lcdWriteCommandByte(0x2A); // set column(x) address
    lcdWriteDataWord(_x1);
    lcdWriteDataWord(_x2);
    lcdWriteCommandByte(0x2B); // set Page(y) address
    lcdWriteDataWord(_y1);
    lcdWriteDataWord(_y2);
    lcdWriteCommandByte(0x2C); // Memory Write

    for(int i=_x1;i<=_x2;i++){
        for(int j=_y1;j<=_y2;j++){
            lcdWriteDataWord(color);
        }
    }

}
*/
/*
void TFT_lib::displayOff()
{
    lcdWriteCommandByte(0x28);
}
*/
/*
void TFT_lib::displayOn()
{
    lcdWriteCommandByte(0x29);
}
*/

void TFT_lib::inversionOff()
{
    lcdWriteCommandByte(0x20);
}


void TFT_lib::inversionOn()
{
    lcdWriteCommandByte(0x21);
}

void TFT_lib::drawImage(QImage image)
{
    int _width = dev._width;    
    int _height = dev._height;
    uint16_t offsetX = 0;
    uint16_t offsetY = 0;
    //la imagen se muestra en espejo para ser vista desde el otro lado de la pantalla. Hay que darla la vuelta
    int ypos = (_height-1) - offsetY;

    for(int y = 0; y < _height; y++){
        for(int x = 0;x < _width; x++){            
            uint16_t color = rgb565_conv(image.pixelColor(x,y).red() , image.pixelColor(x,y).green(), image.pixelColor(x,y).blue());
            //drawPixel(x-offsetX, ypos, image.pixel(x,y));
            drawPixel(x-offsetX, ypos, color);            
        }
        ypos--;
    }
}

//configuración de los GPIOS de la RaspberryPi desde el fichero indicado en la ruta
void TFT_lib::setInterface(TFT_lib::TFT_t *dev, char *ppath)
{
    if(_DEBUG_)qDebug()<<"\x1B[34m===============================setInterface Init===============================\x1B[0m";
//    configuración inicial
/*    dev->pins.rst = 7;
    dev->pins.cs  = 8;
    dev->pins.rs  = 9;
    dev->pins.wr  = 11;
    dev->pins.rd  = 31;
    dev->pins.d0  = 21;
    dev->pins.d1  = 22;
    dev->pins.d2  = 23;
    dev->pins.d3  = 24;
    dev->pins.d4  = 25;
    dev->pins.d5  = 26;
    dev->pins.d6  = 27;
    dev->pins.d7  = 28;
*/
    //pines reformateados por Fernando con la configuración de WiringPi

    dev->pins.rst = 7;
    dev->pins.cs  = 8;
    dev->pins.rs  = 9;
    dev->pins.wr  = 11;
    dev->pins.rd  = 31;
    dev->pins.d0  = 21;
    dev->pins.d1  = 22;
    dev->pins.d2  = 23;
    dev->pins.d3  = 24;
    dev->pins.d4  = 25;
    dev->pins.d5  = 26;
    dev->pins.d6  = 27;
    dev->pins.d7  = 28;

    //elimino la lectura de fichero hasta que encuentre el error
//    ReadPinConfig(&(dev->pins), ppath);

    pinMode(dev->pins.cs, OUTPUT);
    digitalWrite(dev->pins.cs, HIGH);

    pinMode(dev->pins.rs, OUTPUT);
    digitalWrite(dev->pins.rs, HIGH);

    pinMode(dev->pins.wr, OUTPUT);
    digitalWrite(dev->pins.wr, HIGH);

    pinMode(dev->pins.rd, OUTPUT);
    digitalWrite(dev->pins.rd, HIGH);

    pinMode(dev->pins.rst, OUTPUT);
    digitalWrite(dev->pins.rst, HIGH);

    pinMode(dev->pins.d0, OUTPUT);
    pinMode(dev->pins.d1, OUTPUT);
    pinMode(dev->pins.d2, OUTPUT);
    pinMode(dev->pins.d3, OUTPUT);
    pinMode(dev->pins.d4, OUTPUT);
    pinMode(dev->pins.d5, OUTPUT);
    pinMode(dev->pins.d6, OUTPUT);
    pinMode(dev->pins.d7, OUTPUT);

    if(_DEBUG_)qDebug()<<"\x1B[34m===============================setInterface end===============================\x1B[0m";
}


void TFT_lib::initTables()
{
    if(_DEBUG_)qDebug()<<"\x1B[49m==============================INICIALIZANDO LA TABLA reset_off ==============================\x1B[0m";
    lcdInitTable(reset_off, sizeof(reset_off));
    if(_DEBUG_)qDebug()<<"\x1B[49m==============================    TABLA reset_off FINALIZADA   ==============================\x1B[0m";

    if(_DEBUG_)qDebug()<<"\x1B[49m==============================INICIALIZANDO LA TABLA regValues ==============================\x1B[0m";
    lcdInitTable(regValues, sizeof(regValues));
    if(_DEBUG_)qDebug()<<"\x1B[49m==============================    TABLA regValues FINALIZADA   ==============================\x1B[0m";

    if(_DEBUG_)qDebug()<<"\x1B[49m==============================INICIALIZANDO LA TABLA wake_on   ==============================\x1B[0m";
    lcdInitTable(wake_on, sizeof(wake_on));
    if(_DEBUG_)qDebug()<<"\x1B[49m==============================    TABLA wake_on FINALIZADA     ==============================\x1B[0m";

}


void TFT_lib::lcdWriteByte(uint8_t data)
{
    digitalWrite(dev.pins.d0, data & 1);
    digitalWrite(dev.pins.d1, (data & 2) >> 1);
    digitalWrite(dev.pins.d2, (data & 4) >> 2);
    digitalWrite(dev.pins.d3, (data & 8) >> 3);
    digitalWrite(dev.pins.d4, (data & 16) >> 4);
    digitalWrite(dev.pins.d5, (data & 32) >> 5);
    digitalWrite(dev.pins.d6, (data & 64) >> 6);
    digitalWrite(dev.pins.d7, (data & 128) >> 7);

//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[33m==============================LCDWriteByte init ==============================\x1B[0m";
    //if(_DEBUG_WRITE_BYTE_)qDebug()<<"INICIANDO ESCRITURA DE UN BYTE";

/*    if(_DEBUG_WRITE_BYTE_){
        QString bite;
        if((data & 128) >> 7)bite+="1";else bite+="0";
        if((data & 64) >> 6)bite+="1";else bite+="0";
        if((data & 32) >> 5)bite+="1";else bite+="0";
        if((data & 16) >> 4)bite+="1";else bite+="0";
        if((data & 8) >> 3)bite+="1";else bite+="0";
        if((data & 4) >> 2)bite+="1";else bite+="0";
        if((data & 2) >> 1)bite+="1";else bite+="0";
        if(data & 1) bite+="1";else bite+="0";
//        qDebug()<<bite;
        qDebug()<<"Data: "<<QString::number(data,16).prepend("0x").toUpper()<<", decimal ="<<data << " en bits "<<bite;
    }
    */


    digitalWrite(dev.pins.wr, LOW);
    //delayMicroseconds(10);
    digitalWrite(dev.pins.wr, HIGH);
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"WR=0\n"<<"WR=1\n";
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[33m==============================LCDWriteByte end ==============================\x1B[0m";

}

/*
void TFT_lib::lcdWriteByteLSB(uint8_t data)
{
    QDebug qDebug() = qDebug().nospace().noquote();
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"==============================LCDWriteByteSB init ==============================\n";
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"Data "<<data <<" , que en hexadecimal es 0x "<<QString::number(data,16).prepend("0x").toUpper();
    //comprobación de la información transmitida por el puerto paralelo del display

    if(_DEBUG_WRITE_BYTE_){
        if(data & 1) qDebug()<<" 1";else qDebug()<<" 0";
        if((data & 2) >> 1)qDebug()<<"1";else qDebug()<<"0";
        if((data & 4) >> 2)qDebug()<<"1";else qDebug()<<"0";
        if((data & 8) >> 3)qDebug()<<"1";else qDebug()<<"0";
        if((data & 16) >> 4)qDebug()<<"1";else qDebug()<<"0";
        if((data & 32) >> 5)qDebug()<<"1";else qDebug()<<"0";
        if((data & 64) >> 6)qDebug()<<"1";else qDebug()<<"0";
        if((data & 128) >> 7)qDebug()<<"1";else qDebug()<<"0";
    }

    digitalWrite(dev.pins.d0, (data & 128) >> 7);
    digitalWrite(dev.pins.d1, (data & 64) >> 6);
    digitalWrite(dev.pins.d2, (data & 32) >> 5);
    digitalWrite(dev.pins.d3, (data & 16) >> 4);
    digitalWrite(dev.pins.d4, (data & 8) >> 3);
    digitalWrite(dev.pins.d5, (data & 4) >> 2);
    digitalWrite(dev.pins.d6, (data & 2) >> 1);
    digitalWrite(dev.pins.d7, data & 1);

    digitalWrite(dev.pins.wr, LOW);
    delayMicroseconds(10);
    digitalWrite(dev.pins.wr, HIGH);
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\n==============================LCDWriteByteSB end  ==============================\n";
}
*/
/*
void TFT_lib::lcdWriteWord(uint16_t data)
{
    qDebug()<<"==============================lcdWriteWord init ==============================";
    digitalWrite(dev.pins.cs, LOW);
    digitalWrite(dev.pins.rs, HIGH);
    digitalWrite(dev.pins.rd, HIGH);
    digitalWrite(dev.pins.wr, HIGH);
    lcdWriteByte(data >> 8);
    lcdWriteByte(data);
    digitalWrite(dev.pins.cs, HIGH);
    qDebug()<<"==============================lcdWriteWord end  ==============================";
}*/

void TFT_lib::lcdWriteDataWord(uint16_t data)
{
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[36m==============================lcdWriteDataWord init ==============================\x1B[0m";
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"CS=0\n"<<"RS=1\n"<<"RD=1\n"<<"WR=1\n";
    digitalWrite(dev.pins.cs, LOW);
    digitalWrite(dev.pins.rs, HIGH);
    digitalWrite(dev.pins.rd, HIGH);
    digitalWrite(dev.pins.wr, HIGH);

    //qDebug()<<"Desde lcdWriteDataWord: escribiendo BYTE";
    //uint8_t auxData= (uint8_t) data;

    //lcdWriteByte(auxData);
    //lcdWriteByte(toLSB(auxData));
    //lcdWriteByte(auxData);

    //Original
    lcdWriteByte(data >> 8);
    lcdWriteByte(data);

    digitalWrite(dev.pins.cs, HIGH);
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"CS=1\n";
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[36m==============================lcdWriteDataWord end  ==============================\x1B[0m";
}

/*
void TFT_lib::lcdWriteDataWord_16bit(uint16_t data)
{
    digitalWrite(dev.pins.cs, LOW);
    digitalWrite(dev.pins.rs, HIGH);
    digitalWrite(dev.pins.rd, HIGH);
    digitalWrite(dev.pins.wr, HIGH);
    lcdWriteWord(data);
    digitalWrite(dev.pins.cs, HIGH);
}*/

void TFT_lib::lcdWriteDataByte(uint8_t data)
{
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[34m==============================lcdWriteDataByte init ==============================\x1B[0m";
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"Databyte= "<<QString::number(data,16).prepend("0x").toUpper() <<" , en decimal "<<data;    
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"CS=0\n"<<"RS=1\n"<<"RD=1\n"<<"WR=1\n";
    digitalWrite(dev.pins.cs, LOW);
    digitalWrite(dev.pins.rs, HIGH);
    digitalWrite(dev.pins.rd, HIGH);
    digitalWrite(dev.pins.wr, HIGH);
    //qDebug()<<"Escribiendo un byte: llamando a lcdWriteByte";
    lcdWriteByte(data);

    digitalWrite(dev.pins.cs, HIGH);
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"CS=1";
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[34m==============================lcdWriteDataByte end  ==============================\x1B[0m";
}

uint8_t TFT_lib::toLSB(uint8_t data)
{
    uint8_t auxData8b=0;

    if(_DEBUG_)qDebug()<<"Datos originales: data8b= "<<data<<show8Bits(data);
    QString bitStream;
    for(int i=0;i<8;i++){
        if(BIT_GET(data,i)){
            bitStream+="1";
            BIT_SET(auxData8b,7-i);
        }else{
            bitStream+="0";
            BIT_CLEAR(auxData8b,7-i);
        }
    }
    if(_DEBUG_)qDebug()<<"Cadena resultante ="<<bitStream <<" comprobando el dato en la línea siguiente";
    if(_DEBUG_)qDebug()<<"Datos a LSB: "<<auxData8b<<show8Bits(auxData8b)<<" \n";
    return auxData8b;
}

QString TFT_lib::show16Bits(uint16_t data)
{
    QString auxString;
    //if(_DEBUG_)qDebug()<<"Data 16 bits "<<data <<" , que en hexadecimal es 0x "<<QString::number(data,16).prepend("0x").toUpper();

    (data & 65536) >> 16 ? auxString+="1" : auxString+="0";
    (data & 32768) >> 15 ? auxString+="1" : auxString+="0";
    (data & 16384) >> 14 ? auxString+="1" : auxString+="0";
    (data & 8192) >> 13 ? auxString+="1" : auxString+="0";
    (data & 4096) >> 12 ? auxString+="1" : auxString+="0";
    (data & 2048) >> 11 ? auxString+="1" : auxString+="0";
    (data & 1024) >> 10 ? auxString+="1" : auxString+="0";
    (data & 512) >> 9 ? auxString+="1" : auxString+="0";
    (data & 256) >> 8 ? auxString+="1" : auxString+="0";
    (data & 128) >> 7 ? auxString+="1" : auxString+="0";
    (data & 64) >> 6 ? auxString+="1" : auxString+="0";
    (data & 32) >> 5 ? auxString+="1" : auxString+="0";
    (data & 16) >> 4 ? auxString+="1" : auxString+="0";
    (data & 8) >> 3 ? auxString+="1" : auxString+="0";
    (data & 4) >> 2 ? auxString+="1" : auxString+="0";
    (data & 2) >> 1 ? auxString+="1" : auxString+="0";
    data & 1 ? auxString+="1" : auxString+="0";
    //if(_DEBUG_)qDebug()<<auxString;
    return auxString;
}

QString TFT_lib::show8Bits(uint8_t data)
{
    QString auxString;
    //if(_DEBUG_)qDebug()<<"Data 8 bits "<<data <<" , que en hexadecimal es 0x "<<QString::number(data,16).prepend("0x").toUpper();
    (data & 128) >> 7 ? auxString+="1" : auxString+="0";
    (data & 64) >> 6 ? auxString+="1" : auxString+="0";
    (data & 32) >> 5 ? auxString+="1" : auxString+="0";
    (data & 16) >> 4 ? auxString+="1" : auxString+="0";
    (data & 8) >> 3 ? auxString+="1" : auxString+="0";
    (data & 4) >> 2 ? auxString+="1" : auxString+="0";
    (data & 2) >> 1 ? auxString+="1" : auxString+="0";
    data & 1 ? auxString+="1" : auxString+="0";
    //if(_DEBUG_)qDebug()<<auxString;
    return auxString;
}

/*
void TFT_lib::lcdWriteCommandWord(uint16_t command)
{
    QDebug qDebug() = qDebug().nospace().noquote();
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[31m==============================lcdWriteCommandWord init ==============================\x1B[37m\n";

    digitalWrite(dev.pins.cs, LOW);
    digitalWrite(dev.pins.rs, LOW);
    digitalWrite(dev.pins.rd, HIGH);
    digitalWrite(dev.pins.wr, HIGH);
    lcdWriteByte(command >> 8);
    lcdWriteByte(command);
    digitalWrite(dev.pins.cs, HIGH);
    if(_DEBUG_WRITE_BYTE_)printf("\x1B[31m==============================lcdWriteCommandWord end  ==============================\x1B[37m\n");

}
*/

void TFT_lib::lcdWriteCommandByte(uint8_t command)
{
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[32m==============================lcdWriteCommandByte init ==============================\x1B[0m";
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"CS=0\n"<<"RS=0\n"<<"RD=1\n"<<"WR=1";//ERROR DETECTADO. CAMBIANDO RS DE HIG A LOW
    digitalWrite(dev.pins.cs, LOW);
    digitalWrite(dev.pins.rs, LOW);
    digitalWrite(dev.pins.rd, HIGH);
    digitalWrite(dev.pins.wr, HIGH);
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"*****lcdWriteCommandByte= "<<QString::number(command,16).prepend("0x").toUpper();
    lcdWriteByte(command);
    //lcdWriteByteLSB(command);

    digitalWrite(dev.pins.cs, HIGH);
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"CS=1";
//    if(_DEBUG_WRITE_BYTE_)qDebug()<<"\x1B[32m==============================lcdWriteCommandByte end  ==============================\x1B[0m";
}

/*
void TFT_lib::lcdWriteRegisterByte(uint8_t addr, uint16_t data)
{
    QDebug qDebug() = qDebug().nospace().noquote();

    if(_DEBUG_WRITE_BYTE_)printf("==============================lcdWriteRegisterByte init ==============================\n");
    lcdWriteCommandByte(addr);
    lcdWriteDataWord(data);
    if(_DEBUG_WRITE_BYTE_)printf("==============================lcdWriteRegisterByte end  ==============================\n");

}
*/

void TFT_lib::lcdReset()
{
    if(_DEBUG_)qDebug("\x1B[30m==============================lcdReset init  ==============================");
    //qDebug()<<"RST ="<<dev.pins.rst;
    digitalWrite(dev.pins.rst, HIGH);
    delay(100);
    digitalWrite(dev.pins.rst, LOW);
    delay(100);
    digitalWrite(dev.pins.rst, HIGH);
    delay(100);
    if(_DEBUG_WRITE_BYTE_)qDebug()<<"RST=1\n"<<"RST=0\n"<<"RST=1";
    //hay que recargar las tablas de registro para poder mostrar información de nuevo en la pantalla
    initTables();
    if(_DEBUG_)qDebug("==============================lcdReset end  ==============================\x1B[30m");

}

void TFT_lib::lcdDisplayOff()
{
    lcdWriteCommandByte(0x28);
}

void TFT_lib::lcdDisplayOn()
{
    lcdWriteCommandByte( 0x29);
}

void TFT_lib::lcdInitTable(const void *table, int16_t size)
{
    int i;
    uint8_t *p = (uint8_t *) table;
    bool _DEBUG_INIT_TABLE=false;
    if(_DEBUG_INIT_TABLE)qDebug()<<"==============================INICIALIZANDO TABLA==============================";
    if(_DEBUG_INIT_TABLE)qDebug()<<"Size = "<<size;
    while (size > 0) {
        uint8_t cmd = *p++;
        uint8_t len = *p++;
        if(_DEBUG_INIT_TABLE)qDebug()<<"_______________________________________";
        if (cmd == TFTLCD_DELAY8) {
            if(_DEBUG_INIT_TABLE)qDebug()<<"Registro: cmd TFTLCD_DELAY8 :0x"<<QString::number(cmd,16).prepend("0x").toUpper()<<" delay "<<len<<"\n_______________________________________";
            delay(len);
            len = 0;
        } else {
            if(_DEBUG_INIT_TABLE) qDebug()<<"Registro: Ejecutando comando : "<< QString::number(cmd,16).prepend("0x").toUpper();
            lcdWriteCommandByte(cmd);
            for (i = 0; i < len; i++) {
                uint8_t data = *p++;
                if(_DEBUG_INIT_TABLE) qDebug()<<"Registro: Escribiendo dato en Byte: "<<QString::number(data,16).prepend("0x").toUpper();
                lcdWriteDataByte(data);

            }
        }
        size -= len + 2;
        if(_DEBUG_INIT_TABLE)qDebug()<<"Size restante= "<<size;

    }
    if(_DEBUG_INIT_TABLE)qDebug()<<"==========================Tabla inicializada==========================";
}



/*
void TFT_lib::lcdInitResetTable()
{
    qDebug()<<"______________inicializando tablaReset______________";
    for(int i =0;i <9;i++){
        qDebug()<<reset_off[i];
        uint8_t cmd = reset_off[i];
        uint8_t len = reset_off[i+1];
        if(_DEBUG_) qDebug()<<"Comando: "<<cmd;
        if(_DEBUG_) qDebug()<<"Escrituras: "<<len;

        if (cmd == TFTLCD_DELAY8) {
            delay(len);
            len = 0;
        } else {
            lcdWriteCommandByte(cmd);
            for (int j = 0; j < len; j++) {
                uint8_t data = reset_off[i+2+j];
                if(_DEBUG_) qDebug()<<"Registro: "<<data;
                lcdWriteDataByte(data);
            }
        }
        i=i+1+len;

        if(_DEBUG_) qDebug()<<"i="<<i<<"\n----------------------";
//        lcdWriteCommandByte(reset_off[i]);
//        lcdWriteDataByte(reset_off[i]);
    }
    qDebug()<<"______________TablaReset inicializada______________";
}
*/
/*
void TFT_lib::lcdInintRegValuesTable()
{
    qDebug()<<"______________inicializando tabla RegValues______________";
    for(int i =0;i <43;i++){
        qDebug()<<regValues[i];
        uint8_t cmd = regValues[i];
        uint8_t len = regValues[i+1];
        if(_DEBUG_) qDebug()<<"Comando: "<<cmd;
        if(_DEBUG_) qDebug()<<"Escrituras: "<<len;
        if (cmd == TFTLCD_DELAY8) {
            delay(len);
            len = 0;
        } else {
            lcdWriteCommandByte(cmd);
            for (int j = 0; j < len; j++) {
                uint8_t data = regValues[i+2+j];
                if(_DEBUG_) qDebug()<<"Registro: "<<data;
                lcdWriteDataByte(data);
            }
        }
        i=i+1+len;
        if(_DEBUG_) qDebug()<<"----------------------";
//        lcdWriteCommandByte(reset_off[i]);
//        lcdWriteDataByte(reset_off[i]);
    }
    qDebug()<<"______________Tabla RegValues inicializada______________";

}
*/
/*
void TFT_lib::lcdInitWake_on()
{
//    wake_on

    qDebug()<<"______________inicializando tabla wake_on______________";
    for(int i =0;i <6;i++){
        //qDebug()<<regValues[i];
        uint8_t cmd = wake_on[i];
        uint8_t len = wake_on[i+1];
        if(_DEBUG_) qDebug()<<"Comando: "<<cmd;
        if(_DEBUG_) qDebug()<<"Escrituras: "<<len;

        if (cmd == TFTLCD_DELAY8) {
            delay(len);
            len = 0;
        } else {
            lcdWriteCommandByte(cmd);
            for (int j = 0; j < len; j++) {
                uint8_t data = wake_on[i+2+j];
                if(_DEBUG_) qDebug()<<"Registro: "<<data;
                lcdWriteDataByte(data);
            }
        }
        i=i+1+len;
        if(_DEBUG_) qDebug()<<"----------------------";
//        lcdWriteCommandByte(reset_off[i]);
//        lcdWriteDataByte(reset_off[i]);
    }
    qDebug()<<"______________Tabla wake_on inicializada______________";

}
*/
/*

void TFT_lib::lcdDrawPixel(uint16_t x, uint16_t y, uint16_t color)
{
    if(_DEBUG_PIXEL_) qDebug()<<"////////////////////////////////////////////////////////////lcdDrawPixel init ////////////////////////////////////////////////////////////\nDibujando el punto "<<x<<" , "<<y<<" con el color"<<color;
    if (x >= dev._width){
        qDebug()<<"El punto supera la coordenada X de la pantalla"<<x;
        return;
    }

    if (y >= dev._height) {
        qDebug()<<"El punto supera la coordenada Y de la pantalla"<<y;
        return;
    }
    uint16_t _x = x + dev._offsetx;
    uint16_t _y = y + dev._offsety;
    //if(_DEBUG_PIXEL_) qDebug()<<"Punto rectificado"<<_x<<" , "<<_y<<" con el color"<<QString::number(color,16).prepend("0x");

    lcdWriteCommandByte(0x2A); // set column(x) address
    lcdWriteDataWord( _x);
    lcdWriteDataWord( _x);
    lcdWriteCommandByte(0x2B); // set Page(y) address
    lcdWriteDataWord( _y);
    lcdWriteDataWord( _y);
    lcdWriteCommandByte(0x2C); // Memory Write

//#ifndef P16BIT
    lcdWriteDataWord(color);
    if(_DEBUG_PIXEL_) qDebug()<<"////////////////////////////////////////////////////////////lcdDrawPixel end   ////////////////////////////////////////////////////////////";
//#else
//    lcdWriteDataWord_16bit(color);
//#endif
}
*/

void TFT_lib::lcdDrawFillRect(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color)
{
    if (x1 >= dev._width) return;
    if (x2 >= dev._width) x2 = dev._width-1;
    if (y1 >= dev._height) return;
    if (y2 >= dev._height) y2 = dev._height-1;

    uint16_t _x1 = x1 + dev._offsetx;
    uint16_t _x2 = x2 + dev._offsetx;
    uint16_t _y1 = y1 + dev._offsety;
    uint16_t _y2 = y2 + dev._offsety;
    if(_DEBUG_) qDebug()<<"////////////////////////////////////////////////////////////lcdDrawFillRect init   ////////////////////////////////////////////////////////////";
    lcdWriteCommandByte( (uint8_t) 0x2A); // set column(x) address
    lcdWriteDataWord( _x1);
    lcdWriteDataWord( _x2);
    lcdWriteCommandByte((uint8_t)0x2B); // set Page(y) address
    lcdWriteDataWord( _y1);
    lcdWriteDataWord( _y2);
    lcdWriteCommandByte((uint8_t) 0x2C); // Memory Write

    for(int i=_x1;i<=_x2;i++){
        for(int j=_y1;j<=_y2;j++){
            lcdWriteDataWord(color);
        }
    }
    if(_DEBUG_) qDebug()<<"////////////////////////////////////////////////////////////lcdDrawFillRect init   ////////////////////////////////////////////////////////////";
}


void TFT_lib::fillScreen(uint16_t color)
{
    lcdDrawFillRect( 0, 0, dev._width-1, dev._height-1, color);
}

/*
void TFT_lib::lcdDrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color)
{
    int i;
    int dx,dy;
    int sx,sy;
    int E;

    // distance between two points
    dx = ( x2 > x1 ) ? x2 - x1 : x1 - x2;
    dy = ( y2 > y1 ) ? y2 - y1 : y1 - y2;

    // direction of two point
    sx = ( x2 > x1 ) ? 1 : -1;
    sy = ( y2 > y1 ) ? 1 : -1;

    // inclination < 1
    if ( dx > dy ) {
      E = -dx;
      for ( i = 0 ; i <= dx ; i++ ) {
        lcdDrawPixel( x1, y1, color);
        x1 += sx;
        E += 2 * dy;
        if ( E >= 0 ) {
          y1 += sy;
          E -= 2 * dx;
        }
      }
    // inclination >= 1
    } else {
      E = -dy;
      for ( i = 0 ; i <= dy ; i++ ) {
        lcdDrawPixel( x1, y1, color);
        y1 += sy;
        E += 2 * dx;
        if ( E >= 0 ) {
          x1 += sx;
          E -= 2 * dy;
        }
      }
    }
}
*/

void TFT_lib::initLcd(uint16_t model, int width, int height, int offsetx, int offsety)
{
  dev._model = model;
  dev._width = width;
  dev._height = height;
  dev._offsetx = offsetx;
  dev._offsety = offsety;
  dev._font_direction = DIRECTION0;
  dev._font_fill = false;
  dev._font_underline = false;

}


int TFT_lib::ReadPinConfig(TFT_lib::GPIO_t *pin, char *path)
{
    FILE *fp;
    char buff[128];

    //printf("path=%s\n",path);
    if(_DEBUG_){
        qDebug()<<"\x1B[33m===============================LTFT_lib ReadPinConfig INI===============================\x1B[0m";
        qDebug()<<"ReadPinConfig path"<<path;
    }
    fp = fopen(path,"r");
    if(fp == NULL){
        qDebug()<<"Fichero de configuración inexistente. Utilizando configuración por defecto";
/*
        dev.pins.rst = 4;
        dev.pins.cs  = 2;
        dev.pins.rs  = 3;
        dev.pins.wr  = 7;
        dev.pins.rd  = 31;
        dev.pins.d0  = 5;
        dev.pins.d1  = 6;
        dev.pins.d2  = 13;
        dev.pins.d3  = 19;
        dev.pins.d4  = 26;
        dev.pins.d5  = 12;
        dev.pins.d6  = 16;
        dev.pins.d7  = 20;
*/
        dev.pins.rst = 7;
        dev.pins.cs  = 8;
        dev.pins.rs  = 9;
        dev.pins.wr  = 11;
        dev.pins.rd  = 31;
        dev.pins.d0  = 21;
        dev.pins.d1  = 22;
        dev.pins.d2  = 23;
        dev.pins.d3  = 24;
        dev.pins.d4  = 25;
        dev.pins.d5  = 26;
        dev.pins.d6  = 27;
        dev.pins.d7  = 28;

        qDebug()<<"RST pin= "<<pin->rst;
        qDebug()<<"CS pin= "<<pin->cs;
        qDebug()<<"RS pin= "<<pin->rs;
        qDebug()<<"WR pin= "<<pin->wr;
        qDebug()<<"RD pin= "<<pin->rd;
        qDebug()<<"D0 pin= "<<pin->d0;
        qDebug()<<"D1 pin= "<<pin->d1;
        qDebug()<<"D2 pin= "<<pin->d2;
        qDebug()<<"D3 pin= "<<pin->d3;
        qDebug()<<"D4 pin= "<<pin->d4;
        qDebug()<<"D5 pin= "<<pin->d5;
        qDebug()<<"D6 pin= "<<pin->d6;
        qDebug()<<"D7 pin= "<<pin->d7;
        return 0;
    }

    while (fgets(buff,128,fp) != NULL) {
      //printf("buf=[%s]\n",buff);
      //printf("buff[0]=%x\n",buff[0]);
        //qDebug()<<"buf= "<<buff;
        //qDebug()<<"buf[0]= "<<buff[0];
//      int buffLen = strlen(buff);
      for (int index=0;index<strlen(buff);index++) {
        //printf("buff[%d]=%x\n", index, buff[index]);
        //qDebug()<<"buff["<<index<<"]= "<<buff[index];
        if (buff[index] == '#') buff[index] = 0;
        if (buff[index] == ';') buff[index] = 0;
        if (buff[index] == 0x0d) buff[index] = 0;
        if (buff[index] == 0x0a) buff[index] = 0;
      }
      //printf("buf=%d [%s]\n",strlen(buff), buff);
      if (strlen(buff) == 0) continue;

      //if (buff[0] == '#') continue;
      //if (buff[0] == 0x0a) continue;
      if (strncmp(buff,"RST=",4) == 0) {
        sscanf(buff, "RST=%d", &(pin->rst));
      } else if (strncmp(buff,"RS=",3) == 0) {
        sscanf(buff, "RS=%d", &(pin->rs));
      }  else if (strncmp(buff,"CS=",3) == 0) {
        sscanf(buff, "CS=%d", &(pin->cs));
      } else if (strncmp(buff,"WR=",3) == 0) {
        sscanf(buff, "WR=%d", &(pin->wr));
      } else if (strncmp(buff,"RD=",3) == 0) {
        sscanf(buff, "RD=%d", &(pin->rd));
      } else if (strncmp(buff,"D0=",3) == 0) {
        sscanf(buff, "D0=%d", &(pin->d0));
      } else if (strncmp(buff,"D1=",3) == 0) {
        sscanf(buff, "D1=%d", &(pin->d1));
      } else if (strncmp(buff,"D2=",3) == 0) {
        sscanf(buff, "D2=%d", &(pin->d2));
      } else if (strncmp(buff,"D3=",3) == 0) {
        sscanf(buff, "D3=%d", &(pin->d3));
      } else if (strncmp(buff,"D4=",3) == 0) {
        sscanf(buff, "D4=%d", &(pin->d4));
      } else if (strncmp(buff,"D5=",3) == 0) {
        sscanf(buff, "D5=%d", &(pin->d5));
      } else if (strncmp(buff,"D6=",3) == 0) {
        sscanf(buff, "D6=%d", &(pin->d6));
      } else if (strncmp(buff,"D7=",3) == 0) {
        sscanf(buff, "D7=%d", &(pin->d7));
      }
    }
    fclose(fp);
    //comprobación de los datos
    _DEBUG_=true;
    if(_DEBUG_){
        qDebug()<<"Configuración de los GPIO";
        qDebug()<<"RST pin= "<<pin->rst;
        qDebug()<<"CS pin= "<<pin->cs;
        qDebug()<<"RS pin= "<<pin->rs;
        qDebug()<<"WR pin= "<<pin->wr;
        qDebug()<<"RD pin= "<<pin->rd;
        qDebug()<<"D0 pin= "<<pin->d0;
        qDebug()<<"D1 pin= "<<pin->d1;
        qDebug()<<"D2 pin= "<<pin->d2;
        qDebug()<<"D3 pin= "<<pin->d3;
        qDebug()<<"D4 pin= "<<pin->d4;
        qDebug()<<"D5 pin= "<<pin->d5;
        qDebug()<<"D6 pin= "<<pin->d6;
        qDebug()<<"D7 pin= "<<pin->d7;
    }
    _DEBUG_=true;
    qDebug()<<"\x1B[33m===============================LTFT_lib ReadPinConfig END===============================\x1B[0m";

    return 1;
}
