#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    this->setGeometry(
    QStyle::alignedRect(
        Qt::LeftToRight,
        Qt::AlignCenter,
        this->size(),
        qApp->desktop()->rect()
        //qApp->desktop()->availableGeometry()
    ));
    tft= new TFT_lib();
    P_showWindow();





}

MainWindow::~MainWindow()
{
    delete ui;
}



void MainWindow::on_btnTest_clicked()
{
    uint16_t y1 = tft->dev._height/3;
    uint16_t y2 = (tft->dev._height/3)*2;
    tft->lcdDrawFillRect(0, 0, tft->dev._width-1, y1-1, RED);
    tft->lcdDrawFillRect(0, y1-1, tft->dev._width-1, y2-1, GREEN);
    tft->lcdDrawFillRect(0, y2-1, tft->dev._width-1, tft->dev._height-1, BLUE);

}

void MainWindow::on_btnRectangulo_clicked()
{
    int x=ui->ptxtx->toPlainText().toUInt();
    int y=ui->ptxty->toPlainText().toUInt();
    int x2=ui->ptxtx2->toPlainText().toUInt();
    int y2=ui->pxty2->toPlainText().toUInt();
    if(_DEBUG_){
        qDebug()<<"Dibujando rectángulo";
        qDebug()<<"x1="<<ui->ptxtx->toPlainText();
        qDebug()<<"x2="<<ui->ptxtx2->toPlainText();
        qDebug()<<"y1="<<ui->ptxty->toPlainText();
        qDebug()<<"y2="<<ui->pxty2->toPlainText();
    }
    //La orientación, vertical o apaisada cambia los parámetros. Se inicia en vertical. Lo envío en apaisado
    tft->lcdDrawFillRect(y,x,y2,x2,PURPLE);
    if(_DEBUG_)qDebug()<<"Rectángulo finalizado";
}

void MainWindow::P_mostrarColoresTexto()
{
    qDebug()<<"Colores";
    qDebug()<<"\x1B[0mColor 0";
    qDebug()<<"\x1B[1mColor 1";
    qDebug()<<"\x1B[2mColor 2";
    qDebug()<<"\x1B[3mColor 3";
    qDebug()<<"\x1B[4mColor 4";
    qDebug()<<"\x1B[5mColor 5";
    qDebug()<<"\x1B[6mColor 6";
    qDebug()<<"\x1B[7mColor 7";
    qDebug()<<"\x1B[8mColor 8";
    qDebug()<<"\x1B[9mColor 9";
    qDebug()<<"\x1B[10mColor 10";
    qDebug()<<"\x1B[11mColor 11";
    qDebug()<<"\x1B[12mColor 12";
    qDebug()<<"\x1B[13mColor 13";
    qDebug()<<"\x1B[14mColor 14";
    qDebug()<<"\x1B[15mColor 15";
    qDebug()<<"\x1B[16mColor 16";
    qDebug()<<"\x1B[17mColor 17";
    qDebug()<<"\x1B[18mColor 18";
    qDebug()<<"\x1B[19mColor 19";
    qDebug()<<"\x1B[20mColor 20";
    qDebug()<<"\x1B[21mColor 21";
    qDebug()<<"\x1B[22mColor 22";
    qDebug()<<"\x1B[23mColor 23";
    qDebug()<<"\x1B[24mColor 24";
    qDebug()<<"\x1B[25mColor 25";
    qDebug()<<"\x1B[26mColor 26";
    qDebug()<<"\x1B[27mColor 27";
    qDebug()<<"\x1B[28mColor 28";
    qDebug()<<"\x1B[29mColor 29";
    qDebug()<<"\x1B[30mColor 30";
    qDebug()<<"\x1B[31mColor 31";
    qDebug()<<"\x1B[22mColor 32";
    qDebug()<<"\x1B[33mColor 33";
    qDebug()<<"\x1B[34mColor 34";
    qDebug()<<"\x1B[35mColor 35";
    qDebug()<<"\x1B[36mColor 36";
    qDebug()<<"\x1B[37mColor 37";
    qDebug()<<"\x1B[38mColor 38";
    qDebug()<<"\x1B[39mColor 39";
    qDebug()<<"\x1B[40mColor 40";
    qDebug()<<"\x1B[41mColor 41";
    qDebug()<<"\x1B[42mColor 42";
    qDebug()<<"\x1B[43mColor 43";
    qDebug()<<"\x1B[44mColor 44";
    qDebug()<<"\x1B[45mColor 45";
    qDebug()<<"\x1B[46mColor 46";
    qDebug()<<"\x1B[47mColor 47";
    qDebug()<<"\x1B[48mColor 48";
    qDebug()<<"\x1B[49mColor 49";

}

void MainWindow::P_showWindow()
{
    //Muestro en la pantalla la ventana del programa
    QRect rect= this->rect();
    QPixmap *pixMap= new QPixmap(rect.size());

    this->render(pixMap);
    QPixmap rotate= pixMap->transformed(QMatrix().rotate(270));
    tft->drawImage(rotate.toImage());
}

void MainWindow::on_btnRestet_clicked()
{
    qDebug()<<"Reseting screen";
    tft->lcdReset();
}

void MainWindow::on_btnWindow_clicked()
{
    P_showWindow();
}
