#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include "../tft_lib.h"
#include "s6d1121.h"

void s6d1121_lcdInit(TFT_t *dev, int width, int height, int offsetx, int offsety) {
	lcdInit(dev, 0x1121, width, height, offsetx, offsety);

	static const uint16_t regValues[] = {
		0x0011,0x2004,
		0x0013,0xCC00,
		0x0015,0x2600,
		0x0014,0x252A,
		0x0012,0x0033,
		0x0013,0xCC04,
		0x0013,0xCC06,
		0x0013,0xCC4F,
		0x0013,0x674F,
		0x0011,0x2003,
		0x0030,0x2609,
		0x0031,0x242C,
		0x0032,0x1F23,
		0x0033,0x2425,
		0x0034,0x2226,
		0x0035,0x2523,
		0x0036,0x1C1A,
		0x0037,0x131D,
		0x0038,0x0B11,
		0x0039,0x1210,
		0x003A,0x1315,
		0x003B,0x3619,
		0x003C,0x0D00,
		0x003D,0x000D,
		0x0016,0x0007,
		//0x0001,0x0127,
		0x0001,0x0027,
		0x0002,0x0013,
		0x0003,0x0003,
		0x0008,0x0303,
		0x000A,0x000B,
		0x000B,0x0003,
		0x000C,0x0000,
		0x0041,0x0000,
		0x0050,0x0000,
		0x0060,0x0005,
		0x0070,0x000B,
		0x0071,0x0000,
		0x0078,0x0000,
		0x007A,0x0000,
		0x0079,0x0007,
		//0x0007,0x0051,
		0x0007,0x0053,
		0x0079,0x0000,
	};
	lcdInitTable16(dev, regValues, sizeof(regValues));

	// s6d1121 custom function
	DrawPixel = ili9325_lcdDrawPixel;
	DrawFillRect = ili9325_lcdDrawFillRect;
	DisplayOff = ili9325_lcdDisplayOff;
	DisplayOn = ili9325_lcdDisplayOn;
	InversionOff = ili9325_lcdInversionOff;
	InversionOn = ili9325_lcdInversionOn;
}

