<?php

namespace VisualComposer\Modules\Editors\Attributes\CodeMirror;

if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

use VisualComposer\Framework\Container;
use VisualComposer\Framework\Illuminate\Support\Module;
use VisualComposer\Helpers\Traits\EventsFilters;

class CodeMirrorController extends Container implements Module
{
    use EventsFilters;

    public function __construct()
    {
        $this->addEvent('vcv:frontend:render', 'enqueueEditor');
    }

    protected function enqueueEditor()
    {
        if (function_exists('wp_enqueue_code_editor')) {
            wp_enqueue_code_editor(['type' => 'text/css']);
            wp_enqueue_code_editor(['type' => 'text/javascript']);
        }
    }
}
